/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.config;

import dev.toma.configuration.config.Configurable;
import dev.toma.gunsrpg.util.Interval;

public final class QuestConfig {
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=50.0)
    @Configurable.Comment(value={"Amount of reputation awarded when quest is completed", "Value is multiplied by quest tier"})
    @Configurable.Gui.NumberFormat(value="0.0###")
    public float reputationAwardPerTier = 0.2f;
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=50.0)
    @Configurable.Comment(value={"Amount of reputation lost when quest is failed", "Value is multiplied by quest tier"})
    @Configurable.Gui.NumberFormat(value="0.0###")
    public float reputationLossPerTier = 0.3f;
    @Configurable
    @Configurable.Range(min=6000L)
    @Configurable.Synchronized
    @Configurable.Comment(value={"Quest refresh interval for mayor [ticks]"})
    public long questRefreshInterval = Interval.hours(1).valueIn(Interval.Unit.TICK);
    @Configurable
    @Configurable.Synchronized
    @Configurable.Comment(value={"Will block all possible interaction types inside quest areas"})
    public boolean disableQuestAreaInteractions = true;
}

